//+------------------------------------------------------------------+
//|                                                 bollitoucher.mq4 |
//+------------------------------------------------------------------+

#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"

#property indicator_chart_window
#property indicator_buffers 4
#property  indicator_color1 SlateBlue
#property  indicator_color2 SlateBlue
#property  indicator_color3 LightBlue
#property  indicator_color4 Pink

//
//
//
//
//

extern string TimeFrame       = "Current time frame";
extern int    BollPeriod      = 20;
extern int    BollMethod      = 0;
extern int    BollPrice       = 0;
extern double BollDeviation   = 2.0;

extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = true;
extern bool   alertsOnHighLow = true;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = true;
extern bool   alertsEmail     = false;

//
//
//
//
//

double upBand[];
double dnBand[];
double upArrow[];
double dnArrow[];
double trend[];

//
//
//
//
//

string indicatorFileName;
int    timeFrame;
bool   returnBars;
bool   calculateValue;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
  {
   IndicatorBuffers(5);
    SetIndexBuffer(0,upBand);
    SetIndexBuffer(1,dnBand);
    SetIndexBuffer(2,upArrow); SetIndexStyle(2,DRAW_ARROW); SetIndexArrow(2, 167);
    SetIndexBuffer(3,dnArrow); SetIndexStyle(3,DRAW_ARROW); SetIndexArrow(3, 167);
    SetIndexBuffer(4,trend); 
   
      //
      //
      //
      //
      //
      
      indicatorFileName = WindowExpertName();
      calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
      returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
      timeFrame         = stringToTimeFrame(TimeFrame);
      
      IndicatorShortName(timeFrameToString(timeFrame)+"  bollitoucher ");
   return(0);
}
  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//


int start()
  {
   int counted_bars=IndicatorCounted();
   int i,j,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
           limit=MathMin(Bars-1,Bars-counted_bars-1);
           if (returnBars)  { upBand[0] = limit+1; return(0); }
           
           
   //
   //
   //
   //
   //
           
   if (calculateValue || timeFrame==Period())
   {
             
   for(i = limit; i >= 0; i--)
   {
      double sum  = 0.0;
      double  ma  = iMA(NULL,0,BollPeriod,0,BollMethod,BollPrice,i);
      
      //
      //
      //
      //
      //
      
      for(j=0; j<BollPeriod; j++)
      {
      double pr  = iMA(NULL,0,1,0,MODE_SMA,BollPrice,i+j);
             sum+=(pr-ma)*(pr-ma);
      }
      double StdDev = MathSqrt(sum/BollPeriod);
      
      //
      //
      //
      //
      //
    
      upBand[i] = ma + (StdDev*BollDeviation);
      dnBand[i] = ma - (StdDev*BollDeviation);
      upArrow[i]  = EMPTY_VALUE;
      dnArrow[i]  = EMPTY_VALUE; 
      
      if (High[i] > upBand[i]) dnArrow[i] = High[i] + iATR(NULL,0,20,i)/2.0;
      if ( Low[i] < dnBand[i]) upArrow[i] = Low[i]  - iATR(NULL,0,20,i)/2.0;
      
         trend[i] = 0;                     
            if (alertsOnHighLow)       
            {
               if (High[i] > upBand[i]) trend[i] = -1;
               if (Low[i]  < dnBand[i]) trend[i] =  1;
            }
            else
            {
               if (Close[i] > upBand[i]) trend[i] = -1;
               if (Close[i] < dnBand[i]) trend[i] =  1;
            }
      }
      
      if (!calculateValue) manageAlerts();
    return(0);
    }
    
    //
    //
    //
    //
    //
   
    limit = MathMax(limit,MathMin(Bars,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
    for (i=limit;i>=0; i--)
    {
       int y = iBarShift(NULL,timeFrame,Time[i]);
          upBand[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",BollPeriod,BollMethod,BollPrice,BollDeviation,0,y);
          dnBand[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",BollPeriod,BollMethod,BollPrice,BollDeviation,1,y);
          trend[i]   = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",BollPeriod,BollMethod,BollPrice,BollDeviation,4,y);
          upArrow[i] = EMPTY_VALUE;
          dnArrow[i] = EMPTY_VALUE; 
          if (High[i] > upBand[i]) dnArrow[i] = High[i]+iATR(NULL,0,20,i)/2.0;
          if ( Low[i] < dnBand[i]) upArrow[i] = Low[i] -iATR(NULL,0,20,i)/2.0;
     }
      
   manageAlerts();  
   return(0);         
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] == 1) doAlert(whichBar,"lower");
         if (trend[whichBar] ==-1) doAlert(whichBar,"upper");
      }         
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," "+timeFrameToString(timeFrame)+" BolliToucher price penetrated ",doWhat," band");
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"BolliToucher "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = StringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string StringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}   
 

